package com.company.tp07_04_remotetodoapp2.view;

import android.os.Bundle;
import android.widget.ListView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;

import com.company.tp07_04_remotetodoapp2.R;
import com.company.tp07_04_remotetodoapp2.remote.Todo;
import com.company.tp07_04_remotetodoapp2.view.adapter.TodoListAdapter;
import com.company.tp07_04_remotetodoapp2.viewmodel.TodoViewModel;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    private ListView listView;
    private TodoListAdapter adapter;
    private TodoViewModel todoViewModel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        listView = (ListView) findViewById(R.id.listView);
        ViewModelProvider.AndroidViewModelFactory factory = ViewModelProvider.AndroidViewModelFactory.getInstance(this.getApplication());
        ViewModelProvider viewModelProvider = new ViewModelProvider(this, factory);
        todoViewModel = viewModelProvider.get(TodoViewModel.class);

        MutableLiveData<List<Todo>> liveData = todoViewModel.getTodoList();

        liveData.observe(this, new Observer<List<Todo>>() {
            @Override
            public void onChanged(List<Todo> todos) {
                adapter = new TodoListAdapter(MainActivity.this, R.layout.list_item, todos);
                listView.setAdapter(adapter);
            }
        });
    }

}